
#include "Perus.h"



void PaivitaPuhaltaja( OBJEKTI &Puhaltaja, SIJAINTI &HaluttuSij, double &PuhaltajanNopeus, BONUS &Bon )
{
    while( Etaisyys(Puhaltaja.Sijainti, HaluttuSij) < 5 )
    {
        PuhaltajanNopeus = 0.1;
        HaluttuSij.X = Sattuma( -200, 200 );
        HaluttuSij.Y = 1;
        HaluttuSij.Z = Sattuma( -300, 400 );
    }

    
    VEKTORI PuhV = { Puhaltaja.AsentoM.EteenV().X, 0, Puhaltaja.AsentoM.EteenV().Z };
    VEKTORI HalV = { HaluttuSij.X - Puhaltaja.Sijainti.X, 0, HaluttuSij.Z - Puhaltaja.Sijainti.Z };
    double KulmaXZ = acos( Pistetulo(PuhV, HalV) / ((PuhV.AnnaPituus()*HalV.AnnaPituus())+0.001) );
    
    Puhaltaja.AsentoM.PyoritaY( KulmaXZ*0.4 + KulmaXZ*PuhaltajanNopeus*5*Bon.PuhaltajanNopeusMuutos );
    OrthonormalizeMatrix( Puhaltaja.AsentoM.M );
    
    Puhaltaja.Sijainti.X += Puhaltaja.AsentoM.EteenV().X*PuhaltajanNopeus*Bon.PuhaltajanNopeusMuutos;
    Puhaltaja.Sijainti.Z += Puhaltaja.AsentoM.EteenV().Z*PuhaltajanNopeus*Bon.PuhaltajanNopeusMuutos;
    Puhaltaja.Sijainti.Y = 1;
    
    if( Etaisyys(Puhaltaja.Sijainti, NollaSijainti) > 50 )
    {
        //Puhaltaja.Sijainti = NollaSijainti;
    }
    
}





void KUPLA::Alusta()
{
    
    Aani[0] = Mix_LoadWAV("Tiedostot\\Kuuluva\\aani1.ogg");
    Aani[1] = Mix_LoadWAV("Tiedostot\\Kuuluva\\aani2.ogg");
    Aani[2] = Mix_LoadWAV("Tiedostot\\Kuuluva\\aani3.ogg");
    Aani[3] = Mix_LoadWAV("Tiedostot\\Kuuluva\\aani4.ogg");
    Aani[4] = Mix_LoadWAV("Tiedostot\\Kuuluva\\aani5.ogg");
    
    
    KuplaTyyppi[0].Alusta( "Tiedostot\\Objektit\\Kupla2.txt" );
    KuplaTyyppi[1].Alusta( "Tiedostot\\Objektit\\Kupla1.txt" );
    KuplaTyyppi[2].Alusta( "Tiedostot\\Objektit\\Kupla4.txt" );
    KuplaTyyppi[3].Alusta( "Tiedostot\\Objektit\\Kupla3.txt" );
    for(int i=0; i<4;i++)
    {
        KuplaTyyppi[i].Skaalaus=1.0;

    }
    
    for(int i=0; i<KUPLIENLKM; i++)
    {
        Kup[i].Alusta( KuplaTyyppi[KupTyyppi[i]] );
        OnkoVapaa[i] = true;
    }
    
}
void KUPLA::Puhalla( SIJAINTI PuhaltajanSij )
{
    for(int i=0; i<KUPLIENLKM; i++)
    {
        if( OnkoVapaa[i] )
        {
            KupTyyppi[i] = Sattuma( 0, 3 );
            Kup[i].Alusta( KuplaTyyppi[KupTyyppi[i]] );
            Kup[i].Sijainti = PuhaltajanSij;
            Kup[i].Sijainti.Y += 2.5;
            for(int n=0; n<3; n++){ PyorNopeus[i][n] = Sattuma(0, 2000)*0.0001; }
            NousuNopeus[i] = Sattuma(5, 100)*0.0001;
            OnkoVapaa[i] = false;
            
            break;
        }
    }
    
}

long KUPLA::Paivita(  PAPERPLANE &PP, GRAFIIKKA &GF, BONUS &Bon )
{
    long Pisteet = 0;
    int PuhjennutKupla = -1;
    double PuhjennutKuplaKorkeus = 0;

    
    for(int i=0; i<KUPLIENLKM; i++)
    {
        if( OnkoVapaa[i] == false )
        {
            if( Bon.KuplatPuhki ){ OnkoVapaa[i] = true; }
            
            VEKTORI BonusLiikutusV = { PP.Objekti.Sijainti.X-Kup[i].Sijainti.X, PP.Objekti.Sijainti.Y-Kup[i].Sijainti.Y, PP.Objekti.Sijainti.Z-Kup[i].Sijainti.Z };

            BonusLiikutusV.AsetaPituus( Bon.ImeKupla + Bon.PuhallaKupla );
            if(Bon.ImeKupla + Bon.PuhallaKupla == 0) BonusLiikutusV = NollaVektori;
            
            Kup[i].Sijainti.X += Kup[i].AsentoM.EteenV().X*0.02 + BonusLiikutusV.X;
            Kup[i].Sijainti.Y += Kup[i].AsentoM.EteenV().Y*0.02 + NousuNopeus[i] + BonusLiikutusV.Y;
            Kup[i].Sijainti.Z += Kup[i].AsentoM.EteenV().Z*0.02 + BonusLiikutusV.Z;

            //if(Kup[i].Sijainti.Y > 100){ OnkoVapaa[i] = true; }
            Kup[i].AsentoM.PyoritaX( PyorNopeus[i][0] );
            Kup[i].AsentoM.PyoritaY( PyorNopeus[i][1] );
            Kup[i].AsentoM.PyoritaZ( PyorNopeus[i][2] );
            OrthonormalizeMatrix( Kup[i].AsentoM.M );
            Kup[i].Skaalaus = 0.5 + Kup[i].Sijainti.Y*0.001;
            GF.LisaaObjekti( Kup[i] );
            
            if( (Etaisyys( Kup[i].Sijainti, PP.Objekti.Sijainti)-2.5*Kup[i].Skaalaus) <= 0)
            {
                OnkoVapaa[i] = true;
                PuhjennutKupla = KupTyyppi[i];
                PuhjennutKuplaKorkeus = Kup[i].Sijainti.Y;
                Bon.PPNopeusLisa = (double)Sattuma(800, 1200)*0.00006 + (130.0-PP.Objekti.Sijainti.Y)*0.0025;
                Pisteet = 1;
                
                if(KupTyyppi[i] != PuhkaistavaKuplaTyyppi)
                {
                    PuhjennutKupla = -1;
                    Pisteet = -1;
                }
                
                PuhkaistavaKuplaTyyppi = Sattuma(0, 3);
                
                Mix_Volume( Mix_PlayChannel( -1, Aani[3], 0), 64 );
            }
            if(Sattuma( 0, 10000000) < Kup[i].Sijainti.Y) OnkoVapaa[i] = true;
        }
        
    }


    
    int Arpa;


    Bon.KuplatPuhki = false;
    
    if(PuhjennutKupla != -1)
    {

            
        Arpa = Sattuma( 0, 100);
        switch(PuhjennutKupla)
        {

        case 0:
            if(Arpa >= 30 && Arpa < 50)
            {
                Bon.KuplienTuloNopeus = (double)Sattuma( 50, 500)*0.01; Bon.KuplienTuloNopeusAika = SDL_GetTicks() + 10000;
                Bon.TekstiAika = SDL_GetTicks() + 1000;Bon.TekstiY = 300;Bon.Tyhjaa();
                strcpy(Bon.Teksti[0], LukuSanaksi(Bon.KuplienTuloNopeus+1)); Bon.Teksti[1] = "x bubble-blowing"; Bon.Sanoja = 2;
            }
            
            if(Arpa >= 50 && Arpa < 60)
            {
                Bon.KuplienTuloNopeus = 0; Bon.KuplienTuloNopeusAika = SDL_GetTicks() + 5000;
                Bon.TekstiAika = SDL_GetTicks() + 1000;Bon.TekstiY = 300;Bon.Tyhjaa();
                Bon.Teksti[0] = "Bubbling pause"; Bon.Sanoja = 1;
            }
        break;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        case 1:         

            if(Arpa >= 60 && Arpa < 75)
            {
                Bon.PuhaltajanNopeusMuutos = 2.5; Bon.PuhaltajanNopeusMuutosAika = SDL_GetTicks() + Sattuma(4000, 20000);
                Bon.TekstiAika = SDL_GetTicks() + 1000;Bon.TekstiY = 300;Bon.Tyhjaa();
                Bon.Teksti[0] = "4's got speed-up"; Bon.Sanoja = 1;                
            }
        break;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        case 2:
            if(Arpa < 20)
            {
                Bon.KuplatPuhki = true;
                Bon.Teksti[0] = "Good-bye bubbles...";  Bon.Sanoja = 1;
                Bon.TekstiAika = SDL_GetTicks() + 1000;Bon.TekstiY = 300;Bon.Tyhjaa();
                Mix_Volume( Mix_PlayChannel( -1, Aani[1], 0), 64 );
            }
        break;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        case 3:
            if(Arpa < 20)
            {
                Bon.ImeKupla = (double)Sattuma( 100, 800)*0.0001; Bon.ImeKuplaAika = SDL_GetTicks() + 10000;
                Bon.TekstiAika = SDL_GetTicks() + 1000;Bon.TekstiY = 300;Bon.Tyhjaa();
                Bon.Teksti[0] = "Bubble-sucker"; Bon.Sanoja = 1;
            }
            
            if(Arpa >= 20 && Arpa < 30)
            {
                Bon.PuhallaKupla = (double)Sattuma( 100, 800)*(-0.0001); Bon.PuhallaKuplaAika = SDL_GetTicks() + 10000;
                Bon.TekstiAika = SDL_GetTicks() + 1000;Bon.TekstiY = 300;Bon.Tyhjaa();
                Bon.Teksti[0] = "Bubble-repeller"; Bon.Sanoja = 1;
            }
        break;

        }
    }

    
    return Pisteet;
}

void BONUS::Alusta()
{
    PPNopeusLisa = 0;
    ImeKuplaAika = 0; ImeKupla = 0;
    PuhallaKuplaAika = 0; PuhallaKupla = 0;
    KuplienTuloNopeusAika = 0; KuplienTuloNopeus = 1;
    KuplatPuhki = false;
    PuhaltajanNopeusMuutosAika = 0; PuhaltajanNopeusMuutos = 1;
    Teksti = new char *[10];
    for(int i=0; i<10; i++)
    {
        Teksti[i] = new char;
    }
    Sanoja = 0;
}


void BONUS::Paivita()
{
    if(TekstiAika < SDL_GetTicks())
    {
        if(TekstiY > -500) TekstiY-=4;
        if(TekstiY < -500) Sanoja = 0;
    }
    if(ImeKuplaAika < SDL_GetTicks()) ImeKupla = 0;
    
    if(PuhallaKuplaAika < SDL_GetTicks()) PuhallaKupla = 0;
    
    if(KuplienTuloNopeusAika < SDL_GetTicks()) KuplienTuloNopeus = 1;
    
    if(PuhaltajanNopeusMuutosAika < SDL_GetTicks()) PuhaltajanNopeusMuutos = 1;
}

void BONUS::Tyhjaa()
{
    for(int i=0; i<10; i++)
    {
        delete Teksti[i];
        Teksti[i] = NULL;
        Teksti[i] = new char;
    }
}




void LENTOTIEDOT::Alusta()
{
    LahtoAika = SDL_GetTicks();
    MaxEtaisyys = 0;
    EtaisyysLahdosta = 0;
    MaxKorkeus = 0;
    Korkeus = 0;
    Pisteet = 0;

}

void LENTOTIEDOT::Paivita( KUPLA Kup, PAPERPLANE PP)
{
    LentoAika = SDL_GetTicks() - LahtoAika;
    
    SIJAINTI PPSijainti = { PP.Objekti.Sijainti.X, 0 , PP.Objekti.Sijainti.Z};
    EtaisyysLahdosta = Etaisyys( PPSijainti, NollaSijainti);
    if(EtaisyysLahdosta > MaxEtaisyys) MaxEtaisyys = EtaisyysLahdosta;
    
    Korkeus = PP.Objekti.Sijainti.Y;
    if(Korkeus > MaxKorkeus) MaxKorkeus = Korkeus;
    

}



void PISTEET::Lataa( char *TiedostoNimi )
{
    ifstream Tiedosto( TiedostoNimi, ios_base::binary );
    
    if( Tiedosto.is_open() )
    {
        Tiedosto.read((char *) &*this, sizeof(*this));
        Tiedosto.close();
    }
}


void PISTEET::Tallenna( char *TiedostoNimi )
{
    ofstream Tiedosto( TiedostoNimi, ios_base::binary );

    Tiedosto.write((char *) &*this, sizeof(*this));

    Tiedosto.close();
}
    
    




















